﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Globalization;
using VIRP.AHOBPR.BO;
using System.Web.Script.Serialization;

namespace VIRP.AHOBPR.BLL
{
    public class AHOBPRJsonDataManager
    {
        const string NOTFOUND = "NOT_FOUND";

        public AHOBPRJsonDataManager()
        {
        }

        public bool ParseJsonFollowupData(int jsonQueueFollowupId)
        {
            bool result = false;

            JSON_QUEUE_FOLLOWUP queueFollowup = GetJsonQueueFollowup(jsonQueueFollowupId);
            if (queueFollowup == null)
            {
                result = true;
            }
            else
            {
                int jsonFollowupId = queueFollowup.REGISTRANT_JSON_FOLLOWUP_ID;
                REGISTRANT_JSON_FOLLOWUP registrantJsonFollowup = GetJsonFollowupDataById(jsonFollowupId);
                if (registrantJsonFollowup == null)
                {
                    result = true;
                }
                else
                {
                    if (registrantJsonFollowup.OBJECT_TYPE == AHOBPRGlobal.AhobprJsonTypeResponsesFollowup)
                    {
                        result = ParseResponseJsonFollowup(registrantJsonFollowup.JSON_DATA, queueFollowup);
                    }
                    else
                    {
                        result = true;
                    }
                }
            }

            return result;
        }

        private JSON_QUEUE_FOLLOWUP GetJsonQueueFollowup(int jsonQueueFollowupId)
        {
            return JSON_QUEUE_FOLLOWUPManager.GetItem("RESTful Service", 0, jsonQueueFollowupId);
        }

        private REGISTRANT_JSON_FOLLOWUP GetJsonFollowupDataById(int jsonFollowupId)
        {
            return REGISTRANT_JSON_FOLLOWUPManager.GetItem("RESTful Service", 0, jsonFollowupId);
        }

        private static FOLLOWUP_FORM_RESPONSE GetFirstFollowupFormResponse(BprResponses bprResponses, REGISTRANT registrant)
        {
            return registrant.FOLLOWUP_FORM_RESPONSEs.FirstOrDefault(e => e.STD_FORM.BPR_FORM_ID == bprResponses.formId);
        }

        private bool ParseResponseJsonFollowup(string jsonData, JSON_QUEUE_FOLLOWUP queueFollowup)
        {
            bool result = false;
            JSON_QUEUE_FOLLOWUP_STATUS queueStatus = new JSON_QUEUE_FOLLOWUP_STATUS();
            queueStatus.JSON_QUEUE_FOLLOWUP_ID = queueFollowup.JSON_QUEUE_FOLLOWUP_ID;
            queueStatus.REGISTRANT_JSON_FOLLOWUP_ID = queueFollowup.REGISTRANT_JSON_FOLLOWUP_ID;
            queueStatus.PROCESS_START_DATE = DateTime.Now;
            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
            try
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                serializer.RegisterConverters(new[] { new AnswerJavaScriptConverter() });
                BprResponses bprResponses = serializer.Deserialize<BprResponses>(jsonData);
                if (bprResponses != null)
                {
                    REGISTRANT registrant = REGISTRANTManager.GetRegistrantByUserIdWithFollowupResponse(bprResponses.userId);
                    if (registrant == null)
                    {
                        queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                        queueStatus.PROCESS_STATUS = "failed";
                        queueStatus.PROCESS_ERROR = "Registrant not found";
                        SaveJsonQueueFollowupData(queueStatus);
                        return false;
                    }
                    else
                    {
                        #region registrant found, continue ....
                        //registrant.SetAsChangeTrackingRoot();

                        int formId = STD_FORMManager.GetFollowupFormId(bprResponses.formId);
                        if (formId == 0)
                        {
                            queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                            queueStatus.PROCESS_STATUS = "failed";
                            queueStatus.PROCESS_ERROR = "Form record not found";
                            SaveJsonQueueFollowupData(queueStatus);
                            return false;
                        }
                        else
                        {
                            FOLLOWUP_FORM_RESPONSE response = GetFirstFollowupFormResponse(bprResponses, registrant);
                            if (response == null)
                            {
                                if (STD_FORMManager.IsFormSystemWide(formId))
                                {
                                    bool exists = false;
                                    REGISTRANTManager.AddFollowupQuestionsToOneReigstrant(registrant.REGISTRANT_ID, formId, ref exists);
                                    registrant = REGISTRANTManager.GetRegistrantByUserIdWithFollowupResponse(bprResponses.userId);
                                    //registrant.SetAsChangeTrackingRoot();

                                    response = GetFirstFollowupFormResponse(bprResponses, registrant);
                                }
                                else
                                {
                                    queueStatus.PROCESS_STATUS = "failed";
                                    queueStatus.PROCESS_ERROR = "The form response record is missing in FOLLOWUP_FORM_RESPONSE table";
                                    SaveJsonQueueFollowupData(queueStatus);
                                    return false;
                                }
                            }

                            #region FOLLOWUP_FORM_RESPONSE record found. Continue...
                            response.UPDATED = DateTime.Now;
                            response.UPDATEDBY = "REST Service";

                            response.FOLLOWUP_FORM_RESPONSE_ID = FOLLOWUP_FORM_RESPONSEManager.Save(string.Empty, 0, response);
                            //response.SetAsUpdateOnSubmit();

                            // Process questions and answers data only when the questionnaire is completed
                            if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireCompletedDate))
                            {
                                response.COMPLETED_DATE = DateTimeOffset.Parse(bprResponses.responseStatus.questionnaireCompletedDate).UtcDateTime;

                                //TLB.TODO
                                //ADD Function to delete all questions and answers

                                //#region delete previous questions & answers
                                //// Delete the previous value
                                //foreach (FOLLOWUP_FORM_RESPONSE_QUESTION question in response.FOLLOWUP_FORM_RESPONSE_QUESTIONs)
                                //{
                                //    question.SetAsDeleteOnSubmit();
                                //    foreach (FOLLOWUP_FORM_RESPONSE_ANSWER answer in question.FOLLOWUP_FORM_RESPONSE_ANSWERs)
                                //    {
                                //        answer.SetAsDeleteOnSubmit();
                                //    }
                                //}
                                //#endregion

                                #region insert new values
                                // Insert the new values
                                FOLLOWUP_FORM_RESPONSE_QUESTION sqlQuestion = new FOLLOWUP_FORM_RESPONSE_QUESTION();
                                foreach (BprResponse bprResponse in bprResponses.responses)
                                {
                                    bool hasAnswer = false;
                                    if (bprResponse.answers.Length > 0)
                                    {
                                        hasAnswer |= !string.IsNullOrEmpty(bprResponse.answers[0].answerId);
                                    }

                                    if (!string.IsNullOrEmpty(bprResponse.sectionId) && !string.IsNullOrEmpty(bprResponse.subSectionId)
                                        && !string.IsNullOrEmpty(bprResponse.questionId) && hasAnswer)
                                    {
                                        sqlQuestion = new FOLLOWUP_FORM_RESPONSE_QUESTION();
                                        sqlQuestion.FOLLOWUP_FORM_RESPONSE_ID = response.FOLLOWUP_FORM_RESPONSE_ID;
                                        sqlQuestion.STARTED_DATE = ParseGmtDateTime(bprResponses.responseStatus.questionnaireCompletedDate);
                                        sqlQuestion.COMPLETED_DATE = ParseGmtDateTime(bprResponses.responseStatus.questionnaireCompletedDate);
                                        int sqlQuestionId = STD_FORMManager.GetFormQuestionIdForFollowupQuestion(formId, bprResponse.questionId);
                                        if (sqlQuestionId > 0)
                                        {
                                            sqlQuestion.STD_FORM_QUESTION_ID = sqlQuestionId;
                                            int deploymentId = STD_FORMManager.GetDeploymentId(registrant.REGISTRANT_ID, bprResponse.deploymentId);
                                            if (bprResponse.answers.Length > 0)
                                            {
                                                sqlQuestion.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = FOLLOWUP_FORM_RESPONSE_QUESTIONManager.Save(string.Empty, 0, sqlQuestion);
                                                response.FOLLOWUP_FORM_RESPONSE_QUESTIONs.Add(sqlQuestion);
                                                //sqlQuestion.SetAsInsertOnSubmit();

                                                foreach (BprAnswer bprAnswer in bprResponse.answers)
                                                {
                                                    FOLLOWUP_FORM_RESPONSE_ANSWER sqlAnswer = new FOLLOWUP_FORM_RESPONSE_ANSWER();
                                                    sqlAnswer.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = sqlQuestion.FOLLOWUP_FORM_RESPONSE_QUESTION_ID;
                                                    if (!string.IsNullOrEmpty(bprAnswer.answerValue))
                                                    {
                                                        sqlAnswer.ANSWER_VALUE = bprAnswer.answerValue;
                                                    }
                                                    int sqlAnswerId = STD_FORMManager.GetFormAnswerId(sqlQuestionId, bprAnswer.answerId);
                                                    if (sqlAnswerId > 0)
                                                    {
                                                        sqlAnswer.STD_FORM_ANSWER_ID = sqlAnswerId;
                                                        sqlAnswer.FOLLOWUP_FORM_RESPONSE_ANSWER_ID = FOLLOWUP_FORM_RESPONSE_ANSWERManager.Save(string.Empty, 0, sqlAnswer);
                                                        sqlQuestion.FOLLOWUP_FORM_RESPONSE_ANSWERs.Add(sqlAnswer);
                                                        //sqlAnswer.SetAsInsertOnSubmit();
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }

                                #endregion

                                #region save registrant
                                // Save to SQL database
                                result = (REGISTRANTManager.UpdateRegistrant(registrant) >= 0);

                                if (result)
                                {
                                    queueStatus.PROCESS_STATUS = "success";
                                    SaveJsonQueueFollowupData(queueStatus);
                                }
                                else
                                {
                                    queueStatus.PROCESS_STATUS = "failed";
                                    queueStatus.PROCESS_ERROR = "failed to save to database";
                                    SaveJsonQueueFollowupData(queueStatus);
                                }
                                #endregion
                            }
                            #endregion

                        }
                    }
                    #endregion
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("Parse JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "JSON QueueFollowupId: " + queueStatus.JSON_QUEUE_FOLLOWUP_ID.ToString() + ", Error: " + ex.Message);
                queueStatus.PROCESS_COMPLETE_DATE = DateTime.Now;
                queueStatus.PROCESS_STATUS = "failed";
                queueStatus.PROCESS_ERROR = ex.Message;
                SaveJsonQueueFollowupData(queueStatus);
                result = false;
            }

            return result;
        }

        public REGISTRANT_JSON SaveJsonData(string objectId, string type, string data, string createdBy)
        {
            return SaveJsonData(objectId, type, data, createdBy, 1);
        }

        public REGISTRANT_JSON SaveJsonData(string objectId, string type, string data, string createdBy, int tryCount)
        {
            if (tryCount >= 20)
            {
                string message = "Unable to save JSON Data after 20 tries: {ObjectID:" + objectId + "}, {type:" + type + "},{data:" + data + "}";
                LogManager.LogError(message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                //    "Unable to save JSON Data after 20 tries: {ObjectID:" + objectId + "}, {type:" + type + "},{data:" + data + "}");

                return null;
            }
            if (tryCount > 1)
            {
                string message = "retry #" + tryCount.ToString() + ": {ObjectID:" + objectId + "}";
                LogManager.LogError(message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("Retry", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name,
                //    "retry #" + tryCount.ToString() + ": {ObjectID:" + objectId + "}");
            }
            REGISTRANT_JSON result = null;
            if (string.IsNullOrEmpty(objectId) || string.IsNullOrEmpty(type) || string.IsNullOrEmpty(data))
            {
                return result;
            }
            try
            {
                string createdByString = string.IsNullOrEmpty(createdBy) ? "RESTful Service" : createdBy;
                //Dictionary<String, Object> param = new Dictionary<string, object>();
                //param.Add("@objectId", objectId);
                //param.Add("@objectType", type);
                //param.Add("@jsonData", data);
                //param.Add("@createdBy", createdByString);
                //int registrantJsonId = int.Parse(DbUtil.ExecuteSProc("AHOBPR.sp_InsertRegistrantJson", param)[0][0].ToString());

                result = new REGISTRANT_JSON();
                result.OBJECT_ID = objectId;
                result.OBJECT_TYPE = type;
                result.JSON_DATA = data;
                result.CREATED = DateTime.Now;
                result.CREATEDBY = createdByString;
                result.UPDATED = DateTime.Now;
                result.UPDATEDBY = createdByString;

                result.REGISTRANT_JSON_ID = REGISTRANT_JSONManager.Save("RESTful Service", 0, result);
            }
            catch (Exception ex)
            {
                string message = ex.Message + "; Object: {ObjectID:" + objectId + "}, {type:" + type + "}; " + ex.StackTrace;
                LogManager.LogError(message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; Object: {ObjectID:" + objectId + "}, {type:" + type + "}; " + ex.StackTrace);
                result = SaveJsonData(objectId, type, data, createdBy, tryCount + 1);
            }
            return result;
        }

        public void SaveJsonQueueData(JSON_QUEUE queue)
        {
            JSON_QUEUEManager.Save("RESTful Service", 0, queue);

            //try
            //{
            //    Dictionary<String, Object> param = new Dictionary<string, object>();
            //    param.Add("@jsonQueueId", queue.JSON_QUEUE_ID);
            //    param.Add("@registrantJsonId", queue.REGISTRANT_JSON_ID);
            //    param.Add("@processStartDate", queue.PROCESS_START_DATE);
            //    param.Add("@processCompleteDate", queue.PROCESS_COMPLETE_DATE);
            //    param.Add("@processStatus", queue.PROCESS_STATUS == null ? " " : queue.PROCESS_STATUS);
            //    param.Add("@processError", queue.PROCESS_ERROR == null ? " " : queue.PROCESS_ERROR);
            //    param.Add("@createdBy", "RESTful Service");
            //    DbUtil.ExecuteSProc("AHOBPR.sp_InsertJsonQueue", param);
            //}
            //catch (Exception ex)
            //{
            //    _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
            //}
        }

        public void SaveJsonQueueFollowupData(JSON_QUEUE_FOLLOWUP_STATUS queueFollowupStatus)
        {
            JSON_QUEUE_FOLLOWUP_STATUSManager.Save("RESTful Service", 0, queueFollowupStatus);

            //try
            //{
            //    Dictionary<String, Object> param = new Dictionary<string, object>();
            //    param.Add("@jsonQueueFollowupId", queueFollowupStatus.JSON_QUEUE_FOLLOWUP_ID);
            //    param.Add("@registrantJsonFollowupId", queueFollowupStatus.REGISTRANT_JSON_FOLLOWUP_ID);
            //    param.Add("@processStartDate", queueFollowupStatus.PROCESS_START_DATE);
            //    param.Add("@processCompleteDate", queueFollowupStatus.PROCESS_COMPLETE_DATE);
            //    param.Add("@processStatus", queueFollowupStatus.PROCESS_STATUS == null ? " " : queueFollowupStatus.PROCESS_STATUS);
            //    param.Add("@processError", queueFollowupStatus.PROCESS_ERROR == null ? " " : queueFollowupStatus.PROCESS_ERROR);
            //    param.Add("@createdBy", "RESTful Service");
            //    DbUtil.ExecuteSProc("AHOBPR.SP_InsertJsonQueueFollowup", param);
            //}
            //catch (Exception ex)
            //{
            //    _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; " + ex.StackTrace);
            //}
        }

        public bool ParseJsonData(int jsonQueueId)
        {
            bool result = false;
            JSON_QUEUE queue = GetJsonQueue(jsonQueueId);
            if (queue == null)
            {
                result = true;
            }
            else
            {
                int jsonId = queue.REGISTRANT_JSON_ID;
                REGISTRANT_JSON registrantJson = GetJsonDataById(jsonId);
                if (registrantJson == null)
                {
                    result = true;
                }
                else
                {
                    if (registrantJson.OBJECT_TYPE == AHOBPRGlobal.AhobprJsonDataTypeUser)
                    {
                        result = ParseUserJson(registrantJson.JSON_DATA, queue);
                    }
                    else if (registrantJson.OBJECT_TYPE == AHOBPRGlobal.AhobprJsonDataTypeInfo)
                    {
                        result = ParseInfoJson(registrantJson.JSON_DATA, queue);
                    }
                    else if (registrantJson.OBJECT_TYPE == AHOBPRGlobal.AhobprJsonDataTypeResponses)
                    {
                        result = ParseResponseJson(registrantJson.JSON_DATA, queue);
                    }
                    else if (registrantJson.OBJECT_TYPE == AHOBPRGlobal.AhobprJsonDataTypeForm)
                    {
                        result = ParseFormJson(registrantJson.JSON_DATA, queue);
                    }
                    else
                    {
                        result = true;
                    }

                }
            }

            return result;
        }

        private JSON_QUEUE GetJsonQueue(int jsonQueueId)
        {
            return JSON_QUEUEManager.GetItem("RESTful Service", 0, jsonQueueId);
        }

        private REGISTRANT_JSON GetJsonDataById(int jsonId)
        {
            return REGISTRANT_JSONManager.GetItem("RESTful Service", 0, jsonId);
        }

        private bool ParseUserJson(string jsonData, JSON_QUEUE queue)
        {
            bool result = false;
            //queue.SetAsChangeTrackingRoot();
            //queue.SetAsUpdateOnSubmit();
            queue.PROCESS_START_DATE = DateTime.Now;
            try
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                BprUser bprUser = serializer.Deserialize<BprUser>(jsonData);
                if (bprUser != null)
                {
                    result = ParseUserJson(jsonData);

                    queue.PROCESS_COMPLETE_DATE = DateTime.Now;
                    if (result)
                    {
                        queue.PROCESS_STATUS = "success";
                        SaveJsonQueueData(queue);
                    }
                    else
                    {
                        queue.PROCESS_STATUS = "failed";
                        SaveJsonQueueData(queue);
                        SaveJsonData(bprUser.userId, AHOBPRGlobal.AhobprJsonDataTypeUser, jsonData, "Failed Save");
                    }
                }

            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "JSON QueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: " + ex.Message);
                queue.PROCESS_COMPLETE_DATE = DateTime.Now;
                queue.PROCESS_STATUS = "failed";
                queue.PROCESS_ERROR = ex.Message;
                SaveJsonQueueData(queue);
                result = false;
            }

            return result;
        }

        public bool ParseUserJson(string jsonData)
        {
            throw new NotImplementedException();
            //bool result = false;
            //try
            //{
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    BprUser bprUser = serializer.Deserialize<BprUser>(jsonData);
            //    if (bprUser != null)
            //    {
            //        REGISTRANT registrant = REGISTRANTManager.GetRegistrantByUserId(bprUser.userId);
            //        registrant = REGISTRANTManager.InitializeRegistrantDBObject(registrant);


            //        registrant.SNUM = bprUser.ssn;
            //        registrant.USER_ID = bprUser.userId;
            //        SetRegistrantNameFields(bprUser, registrant, NOTFOUND);
            //        registrant.EDIPI = bprUser.edipi == NOTFOUND ? string.Empty : bprUser.edipi;
            //        if (!string.IsNullOrEmpty(bprUser.dob) && bprUser.dob != NOTFOUND)
            //        {
            //            // the birth date is UTC time
            //            registrant.BIRTH_DATE = DateTimeOffset.Parse(bprUser.dob).UtcDateTime;
            //        }
            //        if (!string.IsNullOrEmpty(bprUser.userState.lastUpdated))
            //        {
            //            registrant.REGISTRANT_STATUS_LAST_UPDATED_DATE = DateTimeOffset.Parse(bprUser.userState.lastUpdated).UtcDateTime;
            //        }
            //        registrant.DECEASED_FLAG = false;
            //        SetStdRegistrantStatus(bprUser, registrant);

            //        if (!String.IsNullOrEmpty(bprUser.icn) && bprUser.icn != NOTFOUND)
            //        {
            //            registrant.ICN = bprUser.icn;
            //        }
            //        if (!String.IsNullOrEmpty(bprUser.gender) && bprUser.gender != NOTFOUND)
            //        {
            //            registrant.GENDER = bprUser.gender;
            //        }
            //        SetServiceStatus(registrant);
            //        result = (REGISTRANTManager.UpdateRegistrant(registrant) >= 0);
            //    }
            //}
            //catch (Exception ex)
            //{
            //    throw ex;
            //}

            //return result;
        }

        private bool ParseInfoJson(string jsonData, JSON_QUEUE queue)
        {
            throw new NotImplementedException();
            //bool result = false;
            //queue.SetAsChangeTrackingRoot();
            //queue.SetAsUpdateOnSubmit();
            //queue.PROCESS_START_DATE = DateTime.Now;
            //try
            //{
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    BprInfo bprInfo = serializer.Deserialize<BprInfo>(jsonData);
            //    if (bprInfo != null)
            //    {
            //        REGISTRANT registrant = REGISTRANTManager.GetRegistrantByUserIdWithInfo(bprInfo.userId);
            //        if (registrant == null)
            //        {
            //            queue.PROCESS_COMPLETE_DATE = DateTime.Now;
            //            queue.PROCESS_STATUS = "failed";
            //            queue.PROCESS_ERROR = "Registrant not found";
            //            SaveJsonQueueData(queue);
            //        }
            //        else
            //        {
            //            MergeRegistrantPortalJsonWithExistingDatabaseInfo(bprInfo, registrant);
            //            // Save Registrant Info
            //            result = SaveRegistrantInfo(jsonData, queue, registrant);
            //        }
            //    }
            //}
            //catch (Exception ex)
            //{
            //    LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
            //    //_sharedManager.LogErrorMessage("Parse JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "JSON QueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: " + ex.Message);
            //    queue.PROCESS_COMPLETE_DATE = DateTime.Now;
            //    queue.PROCESS_STATUS = "failed";
            //    queue.PROCESS_ERROR = ex.Message;
            //    SaveJsonQueueData(queue);
            //    result = false;
            //}
            //return result;
        }

        private bool ParseResponseJson(string jsonData, JSON_QUEUE queue)
        {
            throw new NotImplementedException();
            //bool result = false;
            //queue.SetAsChangeTrackingRoot();
            //queue.SetAsUpdateOnSubmit();
            //queue.PROCESS_START_DATE = DateTime.Now;
            //try
            //{

            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    serializer.RegisterConverters(new[] { new AnswerJavaScriptConverter() });
            //    BprResponses bprResponses = serializer.Deserialize<BprResponses>(jsonData);
            //    if (bprResponses != null && !string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireStartedDate))
            //    {
            //        // Check user json for status.  Update the status as needed
            //        UpdateUserStatusFromResponseStatus(bprResponses.userId, bprResponses.responseStatus);

            //        // Parse responses data
            //        String contactPreference = "";
            //        REGISTRANT registrant = _registrantManager.GetRegistrantByUserIdWithResponse(bprResponses.userId);
            //        if (registrant == null)
            //        {
            //            MarkQueueEntryAsErrored(queue, "Registrant not found");
            //            result = false;
            //            return result;
            //        }
            //        else
            //        {
            //            registrant.SetAsChangeTrackingRoot();

            //            int formId = _formManager.GetFormId(bprResponses.formId);

            //            if (formId == 0)
            //            {
            //                MarkQueueEntryAsErrored(queue, "Form record not found");
            //                result = false;
            //                return result;
            //            }
            //            else
            //            {
            //                bool responseRecordExist = false;

            //                // Form Response Record
            //                foreach (FORM_RESPONSE response in registrant.FORM_RESPONSEs)
            //                {
            //                    if (response.STD_FORM_ID == formId)
            //                    {
            //                        responseRecordExist = true;
            //                        break;
            //                    }
            //                }
            //                if (responseRecordExist == false)
            //                {
            //                    FORM_RESPONSE formResponse = new FORM_RESPONSE();
            //                    formResponse.REGISTRANT_ID = registrant.REGISTRANT_ID;
            //                    formResponse.STD_FORM_ID = formId;

            //                    registrant.FORM_RESPONSEs.Add(formResponse);
            //                    registrant.FORM_RESPONSEs.Last().SetAsInsertOnSubmit();
            //                }

            //                // Form Response Status Record
            //                foreach (FORM_RESPONSE response in registrant.FORM_RESPONSEs)
            //                {
            //                    if (response.STD_FORM_ID == formId)
            //                    {
            //                        if (response.FORM_RESPONSE_STATUS.Count > 0)
            //                        {
            //                            response.FORM_RESPONSE_STATUS.Last().UPDATED = DateTime.Now;
            //                            response.FORM_RESPONSE_STATUS.Last().UPDATEDBY = "REST Service";
            //                            response.FORM_RESPONSE_STATUS.Last().SetAsUpdateOnSubmit();
            //                        }
            //                        else
            //                        {
            //                            FORM_RESPONSE_STATUS status = new FORM_RESPONSE_STATUS();
            //                            response.FORM_RESPONSE_STATUS.Add(status);
            //                            response.FORM_RESPONSE_STATUS.Last().SetAsInsertOnSubmit();
            //                        }
            //                        response.FORM_RESPONSE_STATUS.Last().FORM_RESPONSE_ID = response.FORM_RESPONSE_ID;
            //                        if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireStartedDate))
            //                        {
            //                            response.FORM_RESPONSE_STATUS.Last().QUESTIONNAIRE_STARTED_DATE = DateTimeOffset.Parse(bprResponses.responseStatus.questionnaireStartedDate).UtcDateTime;
            //                        }
            //                        if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireCompletedDate))
            //                        {
            //                            response.FORM_RESPONSE_STATUS.Last().QUESTIONNAIRE_COMPLETED_DATE = DateTimeOffset.Parse(bprResponses.responseStatus.questionnaireCompletedDate).UtcDateTime;
            //                        }

            //                        if (!string.IsNullOrEmpty(bprResponses.responseStatus.lastSectionId))
            //                        {
            //                            int sectionId = _formManager.GetSectionId(formId, Convert.ToInt32(bprResponses.responseStatus.lastSectionId));
            //                            response.FORM_RESPONSE_STATUS.Last().LAST_SECTION_ID = sectionId;

            //                            if (!string.IsNullOrEmpty(bprResponses.responseStatus.lastSubSectionId))
            //                            {
            //                                response.FORM_RESPONSE_STATUS.Last().LAST_SUB_SECTION_ID = _formManager.GetSubSectionId(formId, sectionId, Convert.ToInt32(bprResponses.responseStatus.lastSubSectionId));
            //                            }
            //                        }

            //                        // Process questions and answers data only when the questionnaire is completed
            //                        if (!string.IsNullOrEmpty(bprResponses.responseStatus.questionnaireCompletedDate))
            //                        {
            //                            // Make sure all the deployments exists in the REGISTRANT_DEPLOYMENT table.
            //                            // If not, reprocess the info object to find the the deployment records.
            //                            // if the deployments cannot be found in the info object, then fail.
            //                            if (AllDeploymentsExist(queue.REGISTRANT_JSON_ID, jsonData, registrant.REGISTRANT_ID))
            //                            {


            //                                // Delete the previous value
            //                                foreach (FORM_RESPONSE_QUESTION question in response.FORM_RESPONSE_QUESTIONs)
            //                                {
            //                                    question.SetAsDeleteOnSubmit();
            //                                    foreach (FORM_RESPONSE_ANSWER answer in question.FORM_RESPONSE_ANSWERs)
            //                                    {
            //                                        answer.SetAsDeleteOnSubmit();
            //                                    }
            //                                }

            //                                // Insert the new values
            //                                FORM_RESPONSE_QUESTION sqlQuestion = new FORM_RESPONSE_QUESTION();
            //                                foreach (BprResponse bprResponse in bprResponses.responses)
            //                                {
            //                                    bool hasAnswer = false;
            //                                    if (bprResponse.answers.Length > 0)
            //                                    {
            //                                        if (!string.IsNullOrEmpty(bprResponse.answers[0].answerId))
            //                                        {
            //                                            hasAnswer = true;
            //                                        }
            //                                    }

            //                                    if (!string.IsNullOrEmpty(bprResponse.sectionId) && !string.IsNullOrEmpty(bprResponse.subSectionId)
            //                                        && !string.IsNullOrEmpty(bprResponse.questionId) && hasAnswer)
            //                                    {
            //                                        sqlQuestion = new FORM_RESPONSE_QUESTION();
            //                                        sqlQuestion.FORM_RESPONSE_ID = response.FORM_RESPONSE_ID;
            //                                        if (!string.IsNullOrEmpty(bprResponse.startedDate) && ParseGmtDateTime(bprResponse.startedDate) != DateTime.MinValue)
            //                                        {
            //                                            sqlQuestion.STARTED_DATE = ParseGmtDateTime(bprResponse.startedDate);
            //                                        }
            //                                        if (!string.IsNullOrEmpty(bprResponse.completedDate) && ParseGmtDateTime(bprResponse.completedDate) != DateTime.MinValue)
            //                                        {
            //                                            sqlQuestion.COMPLETED_DATE = ParseGmtDateTime(bprResponse.completedDate);
            //                                        }

            //                                        int sqlQuestionId = _formManager.GetFormQuestionId(formId, Convert.ToInt32(bprResponse.sectionId), Convert.ToInt32(bprResponse.subSectionId), bprResponse.questionId);
            //                                        if (sqlQuestionId > 0)
            //                                        {
            //                                            sqlQuestion.STD_FORM_QUESTION_ID = sqlQuestionId;
            //                                            int deploymentId = _formManager.GetDeploymentId(registrant.REGISTRANT_ID, bprResponse.deploymentId);
            //                                            if (deploymentId > 0)
            //                                            {
            //                                                sqlQuestion.REGISTRANT_DEPLOYMENT_ID = deploymentId;
            //                                            }
            //                                            else if (!string.IsNullOrEmpty(bprResponse.deploymentId))
            //                                            {
            //                                                MarkQueueEntryAsErrored(queue, "Deployment history cannot be found");
            //                                                return false;
            //                                            }

            //                                            if (bprResponse.answers.Length > 0)
            //                                            {
            //                                                //If there isn't already a form response question for the same question, 
            //                                                //then add it:

            //                                                bool formQuestionAlreadyExists = false;
            //                                                foreach (FORM_RESPONSE_QUESTION q in response.FORM_RESPONSE_QUESTIONs)
            //                                                {
            //                                                    if (q.FORM_RESPONSE_ID == sqlQuestion.FORM_RESPONSE_ID &&
            //                                                        q.STD_FORM_QUESTION_ID == sqlQuestion.STD_FORM_QUESTION_ID
            //                                                               & q.REGISTRANT_DEPLOYMENT_ID == sqlQuestion.REGISTRANT_DEPLOYMENT_ID
            //                                                        && q.LINQEntityState != EntityState.Deleted)
            //                                                    {
            //                                                        formQuestionAlreadyExists = true;
            //                                                        break;
            //                                                    }
            //                                                }

            //                                                if (!formQuestionAlreadyExists)
            //                                                {
            //                                                    response.FORM_RESPONSE_QUESTIONs.Add(sqlQuestion);
            //                                                    response.FORM_RESPONSE_QUESTIONs.Last().SetAsInsertOnSubmit();
            //                                                    foreach (BprAnswer bprAnswer in bprResponse.answers)
            //                                                    {
            //                                                        FORM_RESPONSE_ANSWER sqlAnswer = new FORM_RESPONSE_ANSWER();
            //                                                        sqlAnswer.FORM_RESPONSE_QUESTION_ID = response.FORM_RESPONSE_QUESTIONs.Last().FORM_RESPONSE_QUESTION_ID;
            //                                                        if (!string.IsNullOrEmpty(bprAnswer.answerValue))
            //                                                        {
            //                                                            sqlAnswer.ANSWER_VALUE = bprAnswer.answerValue;

            //                                                            // for weight
            //                                                            if (bprResponse.sectionId == "2" && bprResponse.subSectionId == "3" && bprResponse.questionId == "B")
            //                                                            {
            //                                                                sqlAnswer.ANSWER_VALUE = sqlAnswer.ANSWER_VALUE + " pounds";
            //                                                            }
            //                                                        }
            //                                                        else if (bprAnswer.answerValues.Length > 0)
            //                                                        {
            //                                                            string height = string.Empty;
            //                                                            int index = 0;
            //                                                            foreach (string value in bprAnswer.answerValues)
            //                                                            {
            //                                                                if (!string.IsNullOrEmpty(value))
            //                                                                {
            //                                                                    height = height + value + (index == 0 ? " feet " : " inches");
            //                                                                }
            //                                                                index++;
            //                                                            }
            //                                                            if (!string.IsNullOrEmpty(height))
            //                                                            {
            //                                                                sqlAnswer.ANSWER_VALUE = height;
            //                                                            }
            //                                                        }
            //                                                        int sqlAnswerId = _formManager.GetFormAnswerId(sqlQuestionId, bprAnswer.answerId);
            //                                                        if (sqlAnswerId > 0)
            //                                                        {
            //                                                            sqlAnswer.STD_FORM_ANSWER_ID = sqlAnswerId;
            //                                                            response.FORM_RESPONSE_QUESTIONs.Last().FORM_RESPONSE_ANSWERs.Add(sqlAnswer);
            //                                                            response.FORM_RESPONSE_QUESTIONs.Last().FORM_RESPONSE_ANSWERs.Last().SetAsInsertOnSubmit();

            //                                                            //for contact preference:
            //                                                            if (bprResponse.sectionId == "8" &&
            //                                                                bprResponse.subSectionId == "1" &&
            //                                                                bprResponse.questionId == "A")
            //                                                            {
            //                                                                contactPreference = _formManager.GetFormAnswer(sqlQuestionId, bprAnswer.answerId);
            //                                                            }
            //                                                        }
            //                                                    }
            //                                                }
            //                                            }
            //                                        }
            //                                    }
            //                                }
            //                            }
            //                            else
            //                            {
            //                                LogManager.LogError("JSON QueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: Not all deployments can be found.", String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
            //                                //_sharedManager.LogErrorMessage("Parse JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "JSON QueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: Not all deployments can be found.");
            //                                MarkQueueEntryAsErrored(queue, "Not all deployments can be found");
            //                                return false;
            //                            }
            //                        }
            //                        break;
            //                    }
            //                }

            //            }

            //        }

            //        //If a contact preference was set, make sure it's in AHOBPR.REGISTRANT.CONTACT_PREFERENCE
            //        if (!String.IsNullOrEmpty(contactPreference))
            //        {
            //            registrant.CONTACT_PREFERENCE = contactPreference;
            //        }

            //        // Save to SQL database
            //        result = (REGISTRANTManager.UpdateRegistrant(registrant) >= 0);

            //        //If a contact preference was set, modify any info JSON with the preference.
            //        if (!String.IsNullOrEmpty(contactPreference))
            //        {
            //            UpdateInfoJsonForContactInfo(registrant.USER_ID, contactPreference);
            //        }

            //        queue.PROCESS_COMPLETE_DATE = DateTime.Now;
            //        if (result)
            //        {
            //            queue.PROCESS_STATUS = "success";
            //            SaveJsonQueueData(queue);
            //            _formManager.UpdateRegistrantWithResponseInfo(registrant.REGISTRANT_ID);
            //            //insert into bens queue 
            //            using (var db = GetLocalContext(_connectionInfo))
            //            {
            //                db.SP_InsertIntoBensUpdates(registrant.EDIPI);
            //            }

            //        }
            //        else
            //        {
            //            MarkQueueEntryAsErrored(queue, "failed to save to database");
            //            SaveJsonData(registrant.USER_ID, AHOBPRGlobal.AhobprJsonDataTypeResponses, jsonData, "Failed Save");
            //        }

            //    }
            //    else   // No need to process the response JSON data if questionnaire start date is null
            //    {
            //        queue.PROCESS_COMPLETE_DATE = DateTime.Now;
            //        queue.PROCESS_STATUS = "success";
            //        SaveJsonQueueData(queue);
            //        result = true;
            //    }
            //}
            //catch (Exception ex)
            //{
            //    LogManager.LogError("JasonQueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: " + ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
            //    //_sharedManager.LogErrorMessage("Parse JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, "JasonQueueId: " + queue.JSON_QUEUE_ID.ToString() + ", Error: " + ex.Message);
            //    MarkQueueEntryAsErrored(queue, ex.Message);
            //    SaveJsonQueueData(queue);
            //    result = false;
            //}

            //return result;
        }

        private bool ParseFormJson(String jsonData, JSON_QUEUE queue)
        {
            throw new NotImplementedException();
            //bool result = false;
            //queue.SetAsChangeTrackingRoot();
            //queue.SetAsUpdateOnSubmit();
            //queue.PROCESS_START_DATE = DateTime.Now;
            //try
            //{
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    BprForm bprForm = serializer.Deserialize<BprForm>(jsonData);
            //    if (bprForm != null &&
            //        !string.IsNullOrEmpty(bprForm._id))
            //    {
            //        //The form                    
            //        STD_FORM form = _formManager.GetFormByBprId(bprForm._id);
            //        if (form == null)
            //        {
            //            form = new STD_FORM();
            //            form.SetAsChangeTrackingRoot();
            //            form.BPR_FORM_ID = bprForm._id;
            //            form.CREATEDBY = "REST Service";
            //            form.CREATED = DateTime.Now;
            //            form.SetAsInsertOnSubmit();
            //        }
            //        else
            //        {
            //            form.SetAsChangeTrackingRoot();
            //            form.UPDATED = DateTime.Now;
            //            form.UPDATEDBY = "REST Service";
            //            form.SetAsUpdateOnSubmit();
            //            foreach (STD_FORM_SECTION formSection in form.STD_FORM_SECTIONs)
            //            {
            //                formSection.SetAsDeleteOnSubmit();
            //            }
            //            foreach (STD_FORM_SUB_SECTION subSection in form.STD_FORM_SUB_SECTIONs)
            //            {
            //                subSection.SetAsDeleteOnSubmit();
            //            }
            //            foreach (STD_FORM_QUESTION question in form.STD_FORM_QUESTIONs)
            //            {
            //                question.SetAsDeleteOnSubmit();
            //            }
            //            foreach (STD_FORM_ANSWER answer in form.STD_FORM_ANSWERs)
            //            {
            //                answer.SetAsDeleteOnSubmit();
            //                foreach (STD_FORM_ANSWER_FIELD field in answer.STD_FORM_ANSWER_FIELDs)
            //                {
            //                    field.SetAsDeleteOnSubmit();
            //                }
            //            }
            //        }
            //        form.NAME = bprForm.name;
            //        form.OMB = bprForm.omb;
            //        form.TITLE = bprForm.title;
            //        form.VERSION = bprForm.version;
            //        form.UPDATEDBY = "REST Service";
            //        form.UPDATED = DateTime.Now;

            //        //Form sections:
            //        foreach (BprFormSection bprSection in bprForm.sections)
            //        {
            //            STD_FORM_SECTION formSection = new STD_FORM_SECTION();
            //            formSection.BRP_FORM_SECTION_ID = String.IsNullOrEmpty(bprSection.sectionId) ? (int?)null : int.Parse(bprSection.sectionId);
            //            formSection.LINE_NUMBER = String.IsNullOrEmpty(bprSection.lineNumber) ? (int?)null : int.Parse(bprSection.lineNumber);
            //            formSection.CONCLUSION = String.IsNullOrEmpty(bprSection.conclusion) ? null : bprSection.conclusion;
            //            formSection.DESCRIPTION = String.IsNullOrEmpty(bprSection.description) ? null : bprSection.description;
            //            formSection.INTRODUCTION = String.IsNullOrEmpty(bprSection.introduction) ? null : bprSection.introduction;
            //            formSection.NOTES = String.IsNullOrEmpty(bprSection.notes) ? null : bprSection.notes;
            //            formSection.TITLE = String.IsNullOrEmpty(bprSection.title) ? null : bprSection.title;
            //            formSection.CREATED = DateTime.Now;
            //            formSection.UPDATED = DateTime.Now;
            //            formSection.CREATEDBY = "REST Service";
            //            formSection.UPDATEDBY = "REST Service";
            //            form.STD_FORM_SECTIONs.Add(formSection);
            //            formSection.SetAsInsertOnSubmit();

            //            //Subsections:
            //            foreach (BprFormSubsection bprSubSection in bprSection.subSections)
            //            {
            //                STD_FORM_SUB_SECTION subSection = new STD_FORM_SUB_SECTION();
            //                subSection.BRP_FORM_SUB_SECTION_ID = String.IsNullOrEmpty(bprSubSection.subSectionId) ? (int?)null : int.Parse(bprSubSection.subSectionId);
            //                subSection.TITLE = String.IsNullOrEmpty(bprSubSection.title) ? null : bprSubSection.title;
            //                subSection.INTRODUCTION = String.IsNullOrEmpty(bprSubSection.introduction) ? null : bprSubSection.introduction;
            //                subSection.CONCLUSION = String.IsNullOrEmpty(bprSubSection.conclusion) ? null : bprSubSection.conclusion;
            //                subSection.TITLE = String.IsNullOrEmpty(bprSubSection.title) ? null : bprSubSection.title;
            //                subSection.CREATED = DateTime.Now;
            //                subSection.UPDATED = DateTime.Now;
            //                subSection.CREATEDBY = "REST Service";
            //                subSection.UPDATEDBY = "REST Service";
            //                form.STD_FORM_SUB_SECTIONs.Add(subSection);
            //                formSection.STD_FORM_SUB_SECTIONs.Add(subSection);
            //                subSection.SetAsInsertOnSubmit();

            //                //Questions:
            //                foreach (BprFormQuestion bprQuestion in bprSubSection.questions)
            //                {
            //                    STD_FORM_QUESTION question = new STD_FORM_QUESTION();
            //                    int parentId = int.MinValue;
            //                    int.TryParse(bprQuestion.parent, out parentId);
            //                    question.MAX_CHOICES = bprQuestion.maxChoices;
            //                    question.PARENT_ID = parentId == int.MinValue ? (int?)null : parentId;
            //                    question.BRP_FORM_QUESTION_ID = String.IsNullOrEmpty(bprQuestion.questionId) ? null : bprQuestion.questionId;
            //                    question.SOURCE_ID = String.IsNullOrEmpty(bprQuestion.sourceId) ? null : bprQuestion.sourceId;
            //                    question.TEXT = String.IsNullOrEmpty(bprQuestion.text) ? null : bprQuestion.text;
            //                    question.TYPE = String.IsNullOrEmpty(bprQuestion.type) ? null : bprQuestion.type;
            //                    question.MIN = String.IsNullOrEmpty(bprQuestion.min) ? "" : bprQuestion.min;
            //                    question.MAX = String.IsNullOrEmpty(bprQuestion.max) ? "" : bprQuestion.max;
            //                    question.PRE_REQ_OPERATOR = String.IsNullOrEmpty(bprQuestion.preReqOperator) ? null : bprQuestion.preReqOperator;
            //                    question.CREATED = DateTime.Now;
            //                    question.UPDATED = DateTime.Now;
            //                    question.CREATEDBY = "REST Service";
            //                    question.UPDATEDBY = "REST Service";
            //                    form.STD_FORM_QUESTIONs.Add(question);
            //                    formSection.STD_FORM_QUESTIONs.Add(question);
            //                    subSection.STD_FORM_QUESTIONs.Add(question);
            //                    question.SetAsInsertOnSubmit();

            //                    //Prerequisites:
            //                    /*foreach (BprFormPreReq bprPreReq in bprQuestion.preReq)
            //                    {
            //                        STD_FORM_PRE_REQ_XREF preReq = new STD_FORM_PRE_REQ_XREF();
            //                        preReq.STD_FORM_PRE_REQ_XREF_ID = String.IsNullOrEmpty(bprPreReq.questionId) ? 0 : int.Parse(bprPreReq.questionId);
            //                        preReq.STD_FORM_ANSWER_ID_PRE_REQ = String.IsNullOrEmpty(bprPreReq.questionId) ? 0 : int.Parse(bprPreReq.questionId);
            //                        preReq.CREATED = DateTime.Now;
            //                        preReq.UPDATED = DateTime.Now;
            //                        preReq.CREATEDBY = "REST Service";
            //                        preReq.UPDATEDBY = "REST Service";
            //                        preReq.SetAsInsertOnSubmit();
            //                        question.STD_FORM_PRE_REQ_XREFs.Add(preReq);
            //                    }*/

            //                    //Answers:
            //                    foreach (BprFormAnswer bprAnswer in bprQuestion.answers)
            //                    {
            //                        STD_FORM_ANSWER answer = new STD_FORM_ANSWER();
            //                        answer.ORDER = bprAnswer.order;
            //                        answer.EDITABLE = bprAnswer.editable;
            //                        answer.BRP_FORM_ANSWER_ID = String.IsNullOrEmpty(bprAnswer.answerId) ? null : bprAnswer.answerId;
            //                        answer.TEXT = String.IsNullOrEmpty(bprAnswer.text) ? null : bprAnswer.text;
            //                        answer.HELP = String.IsNullOrEmpty(bprAnswer.help) ? "" : bprAnswer.help;
            //                        answer.CREATED = DateTime.Now;
            //                        answer.UPDATED = DateTime.Now;
            //                        answer.CREATEDBY = "REST Service";
            //                        answer.UPDATEDBY = "REST Service";
            //                        form.STD_FORM_ANSWERs.Add(answer);
            //                        formSection.STD_FORM_ANSWERs.Add(answer);
            //                        subSection.STD_FORM_ANSWERs.Add(answer);
            //                        question.STD_FORM_ANSWERs.Add(answer);
            //                        answer.SetAsInsertOnSubmit();

            //                        //Post Reqs:
            //                        /*foreach (BprFormPostReq bprPostReq in bprAnswer.postReq)
            //                        {
            //                            STD_FORM_POST_REQ_XREF postReq = new STD_FORM_POST_REQ_XREF();
            //                            postReq.STD_FORM_QUESTION_ID_POST_REQ = String.IsNullOrEmpty(bprPostReq.questionId) ? (int?)null : int.Parse(bprPostReq.questionId);
            //                            postReq.CREATED = DateTime.Now;
            //                            postReq.UPDATED = DateTime.Now;
            //                            postReq.CREATEDBY = "REST Service";
            //                            postReq.UPDATEDBY = "REST Service";
            //                            postReq.SetAsInsertOnSubmit();
            //                            answer.STD_FORM_POST_REQ_XREFs.Add(postReq);
            //                        }*/

            //                        //Fields:
            //                        foreach (BprFormField bprField in bprAnswer.fields)
            //                        {
            //                            STD_FORM_ANSWER_FIELD field = new STD_FORM_ANSWER_FIELD();
            //                            field.LABEL = String.IsNullOrEmpty(bprField.label) ? null : bprField.label;
            //                            field.MAX = String.IsNullOrEmpty(bprField.max) ? null : bprField.max;
            //                            field.MIN = String.IsNullOrEmpty(bprField.min) ? null : bprField.min;
            //                            field.CREATED = DateTime.Now;
            //                            field.UPDATED = DateTime.Now;
            //                            field.CREATEDBY = "REST Service";
            //                            field.UPDATEDBY = "REST Service";
            //                            answer.STD_FORM_ANSWER_FIELDs.Add(field);
            //                            field.SetAsInsertOnSubmit();
            //                        }
            //                    }
            //                }
            //            }
            //        }

            //        // Save Form Info
            //        using (_dbAhobpr = GetLocalContext(_connectionInfo))
            //        {
            //            _formManager.SetLoadWithForForms(_dbAhobpr);
            //            result = (_formManager.UpdateForm(form) >= 0);


            //            if (result)
            //            {
            //                queue.PROCESS_COMPLETE_DATE = DateTime.Now;
            //                queue.PROCESS_STATUS = "success";
            //                SaveJsonQueueData(queue);
            //            }
            //            else
            //            {
            //                MarkQueueEntryAsErrored(queue, "Failed to save form.");
            //            }
            //        }
            //    }
            //}
            //catch (Exception ex)
            //{
            //    _sharedManager.LogErrorMessage("Parse JSON Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
            //    result = false;
            //}

            //return result;
        }

        public REGISTRANT_JSON GetJsonData(string id, string type)
        {
            REGISTRANT_JSON jsonData = null;
            if (string.IsNullOrEmpty(id) && string.IsNullOrEmpty(type))
            {
                return jsonData;
            }
            else
            {

                if (type == AHOBPRGlobal.AhobprJsonDataTypeForm && string.IsNullOrEmpty(id))
                {
                    id = AHOBPRGlobal.AhobprDefaultFormId;
                }
                try
                {
                    jsonData = REGISTRANT_JSONManager.GetCurrentJsonFromDb(id, type);
                }
                catch (Exception ex)
                {
                    LogManager.LogError(ex.Message + "\r\n" + ex.StackTrace, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                    //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                }
            }

            return jsonData;
        }

        public bool CreateMessageJson(string registrantId, string emailtemplateid, string createdBy)
        {
            throw new NotImplementedException();
            //bool result = false;

            //if (!string.IsNullOrEmpty(registrantId) && !string.IsNullOrEmpty(emailtemplateid))
            //{
            //    AHOBPRMessageManager messageManager = new AHOBPRMessageManager();
            //    EMAIL_LOG emailLog = messageManager.GetEmailLog(Convert.ToInt32(registrantId), Convert.ToInt32(emailtemplateid));
            //    string userId = REGISTRANTManager.GetUserIdByRegistrantId(Convert.ToInt32(registrantId));
            //    if (emailLog == null)
            //    {
            //        string registrantName = REGISTRANTManager.SelectRegistrantNameById(Convert.ToInt32(registrantId));
            //        AHOBPREmailTemplateManager templateManager = new AHOBPREmailTemplateManager();
            //        EMAIL_TEMPLATE template = templateManager.GetById(Convert.ToInt32(emailtemplateid));
            //        if (template != null)
            //        {
            //            EmailLogManager.LogMail(Convert.ToInt32(registrantId), string.Empty, string.Empty, string.Empty,
            //                HttpUtility.HtmlDecode(template.SUBJECT),
            //                HttpUtility.HtmlDecode(template.SALUTATION + Environment.NewLine + Environment.NewLine + template.BODY + Environment.NewLine + Environment.NewLine + template.CONTACT_INFO).Replace("{REGISTRANTNAME}"
            //                , registrantName),
            //                string.Empty, Convert.ToInt32(emailtemplateid), true, createdBy);
            //        }
            //        emailLog = messageManager.GetEmailLog(Convert.ToInt32(registrantId), Convert.ToInt32(emailtemplateid));
            //    }
            //    BprMessage bprMessage = new BprMessage();
            //    bprMessage._id = emailLog.EMAIL_ID.ToString();
            //    bprMessage.subject = emailLog.SUBJECT;
            //    bprMessage.body = emailLog.BODY;
            //    bprMessage.status = AHOBPRGlobal.AhobprJsonStatusNew;
            //    bprMessage.sentDate = emailLog.EMAIL_SENT.ToString();
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    string jsonData = serializer.Serialize(bprMessage);
            //    REGISTRANT_JSON_FOLLOWUP registrantJsonFollowup = SaveJsonFollowupData(userId, AHOBPRGlobal.AhobprJsonTypeMessage, bprMessage._id, jsonData, AHOBPRGlobal.AhobprJsonStatusNew, "no", createdBy);
            //    if (registrantJsonFollowup != null)
            //    {
            //        result = true;
            //    }
            //}

            //return result;
        }

        public bool CreateUserFormJson(string registrantId, string formId, string createdBy)
        {
            throw new NotImplementedException();
            //bool result = false;
            //if (!string.IsNullOrEmpty(registrantId) && !string.IsNullOrEmpty(formId))
            //{
            //    string objectId = REGISTRANTManager.GetUserIdByRegistrantId(Convert.ToInt32(registrantId));
            //    STD_FORM form = STD_FORMManager.GetFormByStdFormId(formId);
            //    if (!string.IsNullOrEmpty(objectId) && form != null)
            //    {
            //        BprUserFollowupForm userForm = new BprUserFollowupForm();
            //        userForm._id = form.BPR_FORM_ID;
            //        userForm.name = form.NAME;
            //        userForm.title = form.TITLE;
            //        userForm.sentDate = DateTime.Now.ToString();
            //        userForm.status = AHOBPRGlobal.AhobprJsonStatusNew;

            //        JavaScriptSerializer serializer = new JavaScriptSerializer();
            //        string jsonData = serializer.Serialize(userForm);
            //        REGISTRANT_JSON_FOLLOWUP registrantJsonFollowup = SaveJsonFollowupData(objectId, AHOBPRGlobal.AhobprJsonTypeUserForm, userForm._id, jsonData, AHOBPRGlobal.AhobprJsonStatusNew, "no", createdBy);
            //        if (registrantJsonFollowup != null)
            //        {
            //            result = true;
            //        }
            //    }
            //}

            //return result;
        }

        public bool CreateFollowupFormJson(string toolFormId, string isSystemWide, string createdBy)
        {
            throw new NotImplementedException();
            //bool result = false;
            //STD_FORM form = STD_FORMManager.GetFormByToolFormId(toolFormId);
            //if (form != null)
            //{
            //    BprForm bprForm = CreateBprFormObject(form);
            //    JavaScriptSerializer serializer = new JavaScriptSerializer();
            //    string jsonData = serializer.Serialize(bprForm);
            //    REGISTRANT_JSON_FOLLOWUP registrantJsonFollowup = SaveJsonFollowupData(bprForm._id, AHOBPRGlobal.AhobprJsonTypeFormFollowup, bprForm._id, jsonData, string.Empty, isSystemWide, createdBy);
            //    if (registrantJsonFollowup != null)
            //    {
            //        result = true;
            //    }
            //}

            //return result;
        }

        public bool ReopenQuestionnaire(string id)
        {
            bool results = false;

            try
            {
                REGISTRANT_JSON registrantJson = this.GetJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeResponses);
                if (registrantJson != null)
                {
                    JavaScriptSerializer serializer = new JavaScriptSerializer();
                    BprResponses responses = serializer.Deserialize<BprResponses>(registrantJson.JSON_DATA);
                    if (!string.IsNullOrEmpty(responses.responseStatus.questionnaireCompletedDate))
                    {
                        responses.responseStatus.questionnaireCompletedDate = string.Empty;
                        string jsonData = serializer.Serialize(responses);
                        registrantJson = SaveJsonData(id, AHOBPRGlobal.AhobprJsonDataTypeResponses, jsonData, string.Empty);
                        results = (registrantJson != null);
                    }
                    else
                    {
                        results = true;
                    }
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), "RESTful Service", 0);
                //_sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                results = false;
            }

            return results;
        }

        public List<string> GetJsonFollowups(string id, string type)
        {
            List<string> jsonData = new List<string>();
            if (string.IsNullOrEmpty(id) && string.IsNullOrEmpty(type))
            {
                return jsonData;
            }
            else
            {
                List<REGISTRANT_JSON_FOLLOWUP> objTemp = REGISTRANT_JSON_FOLLOWUPManager.GetJsonFollowups(id, type);
                if (objTemp != null)
                {
                    foreach (REGISTRANT_JSON_FOLLOWUP rjf in objTemp)
                    {
                        jsonData.Add(rjf.JSON_DATA.ToString());
                    }
                }

                //try
                //{
                //    Dictionary<String, Object> param = new Dictionary<string, object>();
                //    param.Add("@ObjectType", type);
                //    param.Add("@ObjectId", id);
                //    List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_GetJsonFollowups", param);
                //    foreach (Object[] row in rows)
                //    {
                //        jsonData.Add(row[1].ToString());
                //    }

                //    return jsonData;
                //}
                //catch (Exception ex)
                //{
                //    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                //    return null;
                //}
            }

            return jsonData;
        }

        public string GetJsonFollowup(string id, string type, string instanceId)
        {
            string jsonData = string.Empty;

            if (string.IsNullOrEmpty(id) && string.IsNullOrEmpty(type))
            {
                return jsonData;
            }
            else
            {
                REGISTRANT_JSON_FOLLOWUP objTemp = REGISTRANT_JSON_FOLLOWUPManager.GetJsonFollowup(id, type, instanceId);
                if (objTemp != null)
                    jsonData = objTemp.JSON_DATA.ToString();
                //try
                //{
                //    Dictionary<String, Object> param = new Dictionary<string, object>();
                //    param.Add("@ObjectType", type);
                //    param.Add("@ObjectId", id);
                //    param.Add("@InstanceId", instanceId);
                //    List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_GetJsonFollowup", param);
                //    if (rows.Count > 0)
                //    {
                //        jsonData = rows[0][1].ToString();
                //    }

                //    return jsonData;
                //}
                //catch (Exception ex)
                //{
                //    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                //    return null;
                //}
            }

            return jsonData;
        }

        private DateTime ParseGmtDateTime(string text)
        {
            try
            {
                int gmtIndex = text.IndexOf(" GMT", StringComparison.InvariantCulture);
                int zoneIndex = text.IndexOf(" (", StringComparison.InvariantCulture);

                string localText = text.Substring(0, gmtIndex);
                string offsetText = text.Substring(gmtIndex, zoneIndex - gmtIndex).Replace("GMT", "");

                string format = "ddd MMM d yyyy HH:mm:ss";
                DateTime newDate = DateTime.ParseExact(localText, format, new CultureInfo("en-US"));
                newDate = newDate.AddHours(Convert.ToInt16(offsetText));
                return newDate;
            }
            catch
            {
                return DateTime.MinValue;
            }
        }

        private BprForm CreateBprFormObject(STD_FORM form)
        {
            BprForm bprForm = new BprForm();

            bprForm.name = form.NAME;
            bprForm.title = form.TITLE;
            bprForm.omb = form.OMB;
            bprForm.version = form.VERSION;
            bprForm._id = form.BPR_FORM_ID;

            //section
            BprFormSection bprSection = new BprFormSection();
            List<BprFormSection> bprSections = new List<BprFormSection>();
            STD_FORM_SECTION sqlSection = form.STD_FORM_SECTIONs.First();
            bprSection.sectionId = sqlSection.BRP_FORM_SECTION_ID.ToString();
            bprSection.title = sqlSection.TITLE;
            bprSections.Add(bprSection);
            bprForm.sections = bprSections.ToArray();

            //subSection
            BprFormSubsection bprSubsection = new BprFormSubsection();
            List<BprFormSubsection> bprSubsections = new List<BprFormSubsection>();
            STD_FORM_SUB_SECTION sqlSubsection = form.STD_FORM_SECTIONs.First().STD_FORM_SUB_SECTIONs.First();
            bprSubsection.title = sqlSubsection.TITLE;
            bprSubsection.subSectionId = sqlSubsection.BRP_FORM_SUB_SECTION_ID.ToString();
            bprSubsections.Add(bprSubsection);
            bprSection.subSections = bprSubsections.ToArray();

            //questions
            List<BprFormQuestion> bprQuestions = new List<BprFormQuestion>();
            foreach (STD_FORM_QUESTION sqlQuestion in sqlSubsection.STD_FORM_QUESTIONs)
            {
                BprFormQuestion bprQuestion = new BprFormQuestion();

                bprQuestion.questionId = sqlQuestion.BRP_FORM_QUESTION_ID;
                bprQuestion.text = sqlQuestion.TEXT;
                bprQuestion.type = sqlQuestion.TYPE;
                bprQuestion.min = sqlQuestion.MIN;
                bprQuestion.max = sqlQuestion.MAX;
                bprQuestion.maxChoices = sqlQuestion.MAX_CHOICES.HasValue ? (int)sqlQuestion.MAX_CHOICES : 1;

                bprQuestions.Add(bprQuestion);

                //answers
                List<BprFormAnswer> bprFormAnswers = new List<BprFormAnswer>();
                foreach (STD_FORM_ANSWER sqlAnswer in sqlQuestion.STD_FORM_ANSWERs)
                {
                    BprFormAnswer bprFormAnswer = new BprFormAnswer();
                    bprFormAnswer.answerId = sqlAnswer.BRP_FORM_ANSWER_ID;
                    bprFormAnswer.text = sqlAnswer.TEXT;
                    bprFormAnswer.help = sqlAnswer.HELP;
                    bprFormAnswer.editable = sqlAnswer.EDITABLE;
                    bprFormAnswer.order = sqlAnswer.ORDER;

                    bprFormAnswers.Add(bprFormAnswer);
                }
                bprQuestion.answers = bprFormAnswers.ToArray();
            }
            bprSubsection.questions = bprQuestions.ToArray();

            return bprForm;
        }

        public List<string> GetSystemWideFormJsons()
        {
            List<string> jsonData = new List<string>();

            List<REGISTRANT_JSON_FOLLOWUP> objTemp = REGISTRANT_JSON_FOLLOWUPManager.GetSystemWideFormJson();
            if (objTemp != null)
            {
                foreach(REGISTRANT_JSON_FOLLOWUP temp in objTemp)
                {
                    jsonData.Add(temp.JSON_DATA);
                }
            }

            return jsonData;
            //try
            //{
            //    Dictionary<String, Object> param = new Dictionary<string, object>();
            //    List<Object[]> rows = DbUtil.ExecuteSProc("AHOBPR.SP_GetSystemWideFormJson", param);
            //    foreach (Object[] row in rows)
            //    {
            //        jsonData.Add(row[1].ToString());
            //    }

            //    return jsonData;
            //}
            //catch (Exception ex)
            //{
            //    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
            //    return null;
            //}
        }

        public bool UpdateFollowupFormJsonSystemWide(string toolFormId)
        {
            bool result = false;
            STD_FORM form = STD_FORMManager.GetFormByToolFormId(toolFormId);
            if (form != null)
            {
                REGISTRANT_JSON_FOLLOWUPManager.UpdateFormJsonFollowupSystemWide(form.BPR_FORM_ID, AHOBPRGlobal.AhobprJsonTypeFormFollowup, form.BPR_FORM_ID);
                result = true;

                //try
                //{
                //    Dictionary<String, Object> param = new Dictionary<string, object>();
                //    param.Add("@objectId", form.BPR_FORM_ID);
                //    param.Add("@objectType", AHOBPRGlobal.AhobprJsonTypeFormFollowup);
                //    param.Add("@instanceId", form.BPR_FORM_ID);
                //    DbUtil.ExecuteSProc("AHOBPR.SP_UpdateFormJsonFollowupSystemWide", param);
                //    result = true;
                //}
                //catch (Exception ex)
                //{
                //    _sharedManager.LogErrorMessage("Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "; Object: {ObjectID:" + form.BPR_FORM_ID + "}, {type:" + AHOBPRGlobal.AhobprJsonTypeFormFollowup + "}; " + ex.StackTrace);
                //    result = false;
                //}
            }

            return result;
        }
    }
}
